<?php
    header("Content-Type:application/json");
    include("../connection.php");
   
    if (!isset($_REQUEST["sessi"]) || empty($_REQUEST["sessid"]) ){ header("HTTP/1.1 400"); $msgErr .= "(falta sessionid)";}
    if (!isset($_REQUEST["id"])    || empty($_REQUEST["id"]))     { header("HTTP/1.1 400"); $msgErr .= "(falta id)";}
    
    $salida = new stdClass();
    
    if (empty($msgErr)){
        http_response_code(400);
        $salida->rsp = false;
        $salida->msg = "No se recibio el parámetro". $msgErr;
        echo (json_encode($salida));
        return;
    }

    $sessid = preg_replace("/[^a-zA-Z0-9]/", "", $db->real_escape_string($_REQUEST["sessid"]));
    $id     = intval($db->real_escape_string($_REQUEST["id"]));
    

    // Se valida la session y que no pueda ELIMINAR EL USUARIO a si mismo (mismo id)
    //$sql =  "SELECT sessionvalidthru, DATEDIFF(IFNULL(sessionvalidthru,NOW()), NOW()) active, accs_refuse " .
    //        "FROM   users " .
     //       "WHERE  sessionid = '" . $sessid . "' AND id <> " .$id;
            
    /* Se valida el usuario y la session */
    $sql =  "SELECT id, accs_refuse FROM users ".
            "WHERE  sessionid = ? AND IF(CURDATE()<sessionvalidthru, 1, 0)" ;
   
            
    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("s", $sessid);

    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = false;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }
    //Obtenemos los resultados y recorremos
    $result = $stmt->get_result();
    if (!($rs = mysqli_fetch_array($result))){
    	switch (mysqli_errno($db)){
    	    case 0:
    	    http_response_code(401);
            $salida->rsp = false;
            $salida->msg = "Sesión Invalida o terminada";
            echo (json_encode($salida));
            return;
            break;
        default:
            http_response_code(500);
	        $salida->rsp = false;
            $salida->msg = mysqli_error($db);
            echo (json_encode($salida));
            return;
            break;
        }
    }
    if ($rs["active"] < 0){
        http_response_code(401);
        $salida->rsp = false;
        $salida->msg = "Sesión Invalida o terminada";
        echo (json_encode($salida));
        return;        
    }
    
    // Se verifica si tiene permiso
    if ($rs["accs_refuse"]*1 < 1){
        http_response_code(401);
        $salida->rsp = false ;
        $salida->msg = "No tiene los privilegios para rechazar facturas";
        $salida->name = $rs["name"];
        $salida->accs = $rs["accs_users"]*1;
        $salida->sessid = $sessid;
        echo (json_encode($salida));
        return;
    }

    // Se borra el registro de Documents
    $sql =  "DELETE FROM users WHERE id = ? ";
    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("i", $id);

    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = false;
        $salida->msg = mysqli_error($db);
        //$salida->sql = $sql;
        echo (json_encode($salida));
        return;        
    }

    http_response_code(200);
    $salida->rsp = true;
    $salida->id = $id;
    echo (json_encode($salida));
    return; 

?>