<?php
    header("Content-Type:application/json");
    include("../connection.php");
    $errMsg = "";
    if (!isset($_REQUEST["sessid"]) || empty($_REQUEST["sessid"]) ) { $errMsg .= "No se recibio el Parametro sessid. "; }
    if (!isset($_REQUEST["id"])     || empty($_REQUEST["id"]) )     { $errMsg .= "No se recibio el Parametro id. "; } 
    
    $salida = new stdClass();

    if (!empty($errMsg) ){
        http_response_code(400);
        $salida->msg = $errMsg;
        echo (json_encode($salida));
        return;
    }
    $sessid = preg_replace("/[^a-zA-Z0-9]/", "", $db->real_escape_string($_REQUEST["sessid"]));
    $id     = intval($db->real_escape_string($_REQUEST["id"]));
    
    mysqli_query($db, "SET lc_time_names = 'es_ES'");

    /* Se valida el usuario y la session */
    $sql =  "SELECT id FROM users ".
            "WHERE sessionid = ? ".
            "  AND IF(CURDATE()<sessionvalidthru, 1, 0)" ;

    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("s", $sessid);

    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = false ;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }

    //Obtenemos los resultados y recorremos
    $result = $stmt->get_result();
    if (!($rs = mysqli_fetch_array($result))){
        switch (mysqli_errno($db)){
        case 0:
            http_response_code(401);
            $salida->rsp = false ;
            $salida->msg = "Sesion invalida o terminada";
            $salida->errno = 0;
            //$salida->sql = $sql;
            echo (json_encode($salida));
            return;
            break;
        default:
            http_response_code(500);
            $salida->rsp = false ;
            $salida->msg = mysqli_error($db);
            echo (json_encode($salida));
            return;
            break;
        }
    }

    //$sessid = $_REQUEST["customerid"];

    /* Se valida el usuario y la session */
    $sql =  "SELECT users.id, ".
                "   users.user, ".
                "   users.rif, ".
                "   users.name, ".
                "   users.email, ".
                "   users.status, ".
                "   users.accs_customers, ".
                "   users.accs_users, ".
                "   users.accs_invoices, ".
                "   users.accs_reports, ".
                "   users.accs_approve, ".
                "   users.accs_refuse ".
            "FROM users  " .
            "WHERE users.id = ? " ;

    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("i", $id);

    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = false ;
        //$salida->sql = $sql ;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }
    
    //Obtenemos los resultados y recorremos
    $result = $stmt->get_result();
    if (!($rs = mysqli_fetch_array($result))){
        switch (mysqli_errno($db)){
        case 0:
            http_response_code(401);
            $salida->rsp = false ;
            //$salida->sql = $sql ;
            $salida->msg = "Sesion invalida o terminada";
            $salida->errno = 0;
            echo (json_encode($salida));
            return;
            break;
        default:
            http_response_code(500);
            $salida->rsp = false ;
            //$salida->sql = $sql ;
            $salida->msg = mysqli_error($db);
            echo (json_encode($salida));
            return;
            break;
        }
    }else{

        $userid     = $rs["user"];
        $name       = $rs["name"];
        $email      = $rs["email"];
        if($rs["status"]==1){$status = "on";}else{$status = "";};
        if($rs["accs_customers"]==1){$accs_customers = "on";}else{$accs_customers = "";};
        if($rs["accs_users"]==1){$accs_users = "on";}else{$accs_users = "";};
        if($rs["accs_invoices"]==1){$accs_invoices = "on";}else{$accs_invoices = "";};
        if($rs["accs_reports"]==1){$accs_reports = "on";}else{$accs_reports = "";};
        if($rs["accs_approve"]==1){$accs_approve = "on";}else{$accs_approve = "";};
        if($rs["accs_refuse"]==1){$accs_refuse = "on";}else{$accs_refuse = "";};

        http_response_code(200);
        $salida->rsp = true ;
        $salida->id     = $id;
        $salida->userid = $userid;
        $salida->name   = $name;
        $salida->email  = $email;
        $salida->status = $status;
        $salida->accs_customers = $accs_customers;
        $salida->accs_users = $accs_users;
        $salida->accs_invoices = $accs_invoices;
        $salida->accs_reports = $accs_reports;
        $salida->accs_approve = $accs_approve;
        $salida->accs_refuse = $accs_refuse;
        echo (json_encode($salida));
        return;
    }
    


?>
