<?php
    header("Content-Type:application/json");
    include("../connection.php");
    $errMsg = "";
    $salida = new stdClass();
    if (!isset($_REQUEST["sessid"]) || empty($_REQUEST["sessid"]) ) { $errMsg .= "No se recibio el Parametro sessid. "; }
    if (!isset($_REQUEST["id"])     || empty($_REQUEST["id"]) )     { $errMsg .= "No se recibio el Parametro id. "; } 
    
    if (!empty($errMsg) ){
        
        http_response_code(400);
        $salida->msg = $errMsg;
        echo (json_encode($salida));
        return;
    }
    $sessid = preg_replace("/[^a-zA-Z0-9]/", "", $db->real_escape_string($_REQUEST["sessid"]));
    $id     = intval($db->real_escape_string($_REQUEST["id"]));
    
    mysqli_query($db, "SET lc_time_names = 'es_ES'");

    /* Se valida el usuario y la session */
    $sql =  "SELECT id FROM users WHERE sessionid = ? AND IF(CURDATE()<sessionvalidthru, 1, 0)" ;

    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("s", $sessid);

    //Validamos la ejecución
    if (!($stmt->execute())){
        
        http_response_code(500);
        $salida->rsp = false ;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }

    //Obtenemos los resultados y recorremos
    $result = $stmt->get_result();
    if (!($rs = mysqli_fetch_array($result))){
        switch (mysqli_errno($db)){
        case 0:
            
            http_response_code(401);
            $salida->rsp = false ;
            $salida->msg = "Sesión invalida  o terminada";
            $salida->errno = 0;
            //$salida->sql = $sql;
            echo (json_encode($salida));
            return;
            break;
        default:
            
            http_response_code(500);
            $salida->rsp = false ;
            $salida->msg = mysqli_error($db);
            echo (json_encode($salida));
            return;
            break;
        }
    }

    //$sessid = $db->real_escape_string($_REQUEST["customerid"]);

    /* Se valida el usuario y la session */
    $sql =  "SELECT customers.id, ".
                "   customers.custid, ".
                "   customers.rif, ".
                "   customers.nickname,  ".
                "   customers.name, ".
                "   customers.email, ".
                "   DATE_FORMAT(customers.validthru,'%d/%m/%Y') as validthru, " .
                "   customers.status, ".
                "   customers.failscount, customers.failsmax, ".
                "   customers.blocked ".
            "FROM customers  " .
            "WHERE customers.id = ? ";

    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("i", $id);

    //Validamos la ejecución
    if (!($stmt->execute())){
        
        http_response_code(500);
        $salida->rsp = false ;
        //$salida->sql = $sql ;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }
    
    //Obtenemos los resultados y recorremos
    $result = $stmt->get_result();
    if (!($rs = mysqli_fetch_array($result))){
        switch (mysqli_errno($db)){
        case 0:
            
            http_response_code(401);
            $salida->rsp = false ;
            //$salida->sql = $sql ;
            $salida->msg = "Sesión invalida  o terminada";
            $salida->errno = 0;
            echo (json_encode($salida));
            return;
            break;
        default:
            
            http_response_code(500);
            $salida->rsp = false ;
            //$salida->sql = $sql ;
            $salida->msg = mysqli_error($db);
            echo (json_encode($salida));
            return;
            break;
        }
    }else{

        $customerid = $rs["id"]*1;
        $custid     = $rs["custid"]*1;
        $rif        = $rs["rif"];
        $nickname   = $rs["nickname"];
        $name       = $rs["name"];
        $email      = $rs["email"];
        $validthru  = $rs["validthru"];
        if($rs["status"]==1){$status = "on";}else{$status = "";};
        $failscount = $rs["failscount"]*1;
        $failsmax   = $rs["failsmax"]*1;
        $blocked    = $rs["blocked"]*1;

        
        http_response_code(200);
        $salida->rsp = true ;
        $salida->customerid = $customerid;
        $salida->custid     = $custid;
        $salida->rif        = $rif;
        $salida->nickname   = $nickname;
        $salida->name       = $name;
        $salida->email      = $email;
        $salida->validthru  = $validthru;
        $salida->status     = $status;
        $salida->failscount = $failscount;
        $salida->failsmax   = $failsmax;
        $salida->blocked    = $blocked;
        echo (json_encode($salida));
        return;

        
    }
    


?>
