<?php
//    header("Content-Type:application/json");
    include("../connection.php");
    $errMsg = "";
    
    $salida = new stdClass();
    
    if (!isset($_REQUEST["sessid"])     || empty($_REQUEST["sessid"]) )     { $errMsg .= "No se recibio el Parametro sessid. "; }
    if (!isset($_REQUEST["id"]))                                            { $errMsg .= "No se recibio el Parametro id. "; }
    if (!isset($_REQUEST["custid"])     || empty($_REQUEST["custid"]) )     { $errMsg .= "No se recibio el Parametro custid. "; }
    if (!isset($_REQUEST["rif"])        || empty($_REQUEST["rif"]) )        { $errMsg .= "No se recibio el Parametro rif. "; }
    if (!isset($_REQUEST)               || empty($_REQUEST["nickname"]) )   { $errMsg .= "No se recibio el Parametro nickname. "; }
    if (!isset($_REQUEST["name"])       || empty($_REQUEST["name"]) )       { $errMsg .= "No se recibio el Parametro name. "; }
    if (!isset($_REQUEST["email"])      || empty($_REQUEST["email"]) )      { $errMsg .= "No se recibio el Parametro email. "; }

    $sessid     = preg_replace("/[^a-zA-Z0-9]/", "", $db->real_escape_string($_REQUEST["sessid"]));
    $customerid = intval($db->real_escape_string($_REQUEST["id"]));

    if (isset($_REQUEST["status"]) ){ 
        $status = 1;
    }else{
        $status = 0;
    }

    if(!empty($errMsg)){
        http_response_code(401);
        $salida->rsp = false ;
        $salida->msg = $errMsg;
        echo (json_encode($salida));
        return;
    }
        
    $custid     = intval($db->real_escape_string($_REQUEST["custid"])*1);
    $rif        = preg_replace("/[^JVEGP0-9-]/", "", $db->real_escape_string($_REQUEST["rif"]));
    $nickname   = preg_replace("/[^a-zA-Z0-9 -_@]/", "", $db->real_escape_string($_REQUEST["nickname"]));
    $name       = preg_replace("/[^a-zA-Z0-9 áéíóúÁÉÍÓÚÑñ]/", "", $db->real_escape_string($_REQUEST["name"]));
    $email      = preg_replace("/[^a-zA-Z0-9@-_.]/", "", $db->real_escape_string($_REQUEST["email"]));

    

    mysqli_query($db, "SET lc_time_names = 'es_ES'");
    
    /* Se valida el usuario y la session */
    $sql =  "SELECT id FROM users ".
            "WHERE  sessionid = ? AND IF(CURDATE()<sessionvalidthru, 1, 0)" ;
    
    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("s", $sessid);

    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = false ;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }
    
    //Obtenemos los resultados y recorremos
    $result = $stmt->get_result();
    if (!($rs = mysqli_fetch_array($result))){
        switch (mysqli_errno($db)){
        case 0:
            http_response_code(401);
            $salida->rsp = false ;
            $salida->msg = "Sesión invalida o terminada";
            echo (json_encode($salida));
            return;
            break;
        default:
            http_response_code(500);
            $salida->rsp = false ;
            $salida->msg = mysqli_error($db);
            echo (json_encode($salida));
            return;
            break;
        }
    }


    /************** Validaciones **********************/    
    $errlvl  = 0;
    $errMsg  = "";
    $salir = false;
    
    $errMsg .=  val_registro();      // Validacion Documento

/*
$salida->chk = chkprevreg( "custid   = ".$custid );
echo (json_encode($salida));
return;
*/
    // Se verifica el nivel de error segun la descripción en 0 sin error, 1 Warning, 2 Critical    
    if(empty($errMsg)){
        $errlvl = 0;
    }else{
        $errMsg = parseErrMsg( $errMsg);
        $errlvl = substr($errMsg,0,1)*1;
        $errMsg = substr($errMsg,1);
        http_response_code(200);
        $salida->rsp = false;
        $salida->errlvl = $errlvl;
        $salida->msg = $errMsg;
        echo (json_encode($salida));
        return;
    }


    /* Se valida si el registro es nuevo o no para hacer insert o update */
    $sql =  "SELECT id FROM customers WHERE id = ? ";
    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("i", $customerid);

    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = false ;
        $salida->msg = mysqli_error($db);
        $salida->sql = $sql ;
        echo (json_encode($salida));
        return;
    }
    //Obtenemos los resultados y recorremos
    $result = $stmt->get_result();
    $rs = mysqli_fetch_array($result);
    $numofrecords = mysqli_num_rows($result) ;  

    if ($numofrecords > 0){ $newrecord = false; }else{ $newrecord = true; }

    if($newrecord){
         $sql  = "INSERT INTO customers (" ;
         /*
         if (isset($custid))  {$sql .= "custid";}
         if (isset($rif))     {$sql .= ", rif";}
         if (isset($nickname)){$sql .= ", nickname";}
         if (isset($name))    {$sql .= ", name";}
         if (isset($email))   {$sql .= ", email";}
         if (isset($status))  {$sql .= ", status";}
         if (isset($errlvl))  {$sql .= ", errlvl";}
         if (isset($errMsg))  {$sql .= ", errdsc";}
         $sql .= " ) VALUES ( ";
         if (isset($custid))  {$sql .= $custid;}
         if (isset($rif))     {$sql .= ", '".$rif."'";}
         if (isset($nickname)){$sql .= ", '".$nickname."'";}
         if (isset($name))    {$sql .= ", '".$name."'";}
         if (isset($email))   {$sql .= ", '".$email."'";}
         if (isset($status))  {$sql .= ",  ".$status;}
         if (isset($errlvl))  {$sql .= ",  ".$errlvl;}
         if (isset($errMsg))  {$sql .= ", '".$errMsg."'";}
         $sql .= " )";*/
         $sql .= " custid, rif, nickname, name, email, status, errlvl, errdsc ";
         $sql .= " ) VALUES ( ";
         $sql .= " ?, ?, ?, ?, ?, ?, ?, ? ";
         $sql .= " )";
        //Preparamos el statement
        $stmt =  $db->prepare($sql);
        //Remplazamos los parametros en la consulta almacenada
        $stmt->bind_param("ssssssss", $custid, $rif, $nickname, $name, $email, $status, $errlvl, $errMsg);
    }else{
        $sql =  "UPDATE customers SET " ;
        /*
                if (isset($custid))    {$sql .= " custid   =  "  .$custid. ", ";}
                if (isset($rif))       {$sql .= " rif      = '"  .$rif. "', " ;}
                if (isset($nickname))  {$sql .= " nickname = '"  .$nickname. "'," ;}
                if (isset($name))      {$sql .= " name     = '"  .$name. "'," ;}
                if (isset($email))     {$sql .= " email    = '"  .$email. "'," ;}
                if (isset($status))    {$sql .= " status   =  "  .$status.", " ;}
                if (isset($errlvl))    {$sql .= " errlvl   =  "  .$errlvl.", " ;}
                if (isset($errMsg))    {$sql .= " errdsc   = '"  .$errMsg."' " ;}
        $sql .= "WHERE id = ". $customerid ;*/
        $sql .= " custid   = ?, ";
        $sql .= " rif   = ?, ";
        $sql .= " nickname   = ?, ";
        $sql .= " name   = ?, ";
        $sql .= " email   = ?, ";
        $sql .= " status   = ?, ";
        $sql .= " errlvl   = ?, ";
        $sql .= " errdsc   = ? ";
        $sql .= "WHERE id = ?";
        //Preparamos el statement
        $stmt =  $db->prepare($sql);
        //Remplazamos los parametros en la consulta almacenada
        $stmt->bind_param("sssssssss", $custid, $rif, $nickname, $name, $email, $status, $errlvl, $errMsg, $customerid);
    }

    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = false ;
        $salida->msg = mysqli_error($db);
        $salida->sql = $sql ;
        echo (json_encode($salida));
        return;
    }
    if($newrecord){ $customerid = mysqli_insert_id($db); } // Se recupera el ultimo ID de la mas reciente ejecución de comando SQL    

    if(empty($errMsg)){
        http_response_code(200);
        $salida->rsp        = true;
        $salida->errlvl     = 0;
        $salida->errdsc     = "";
        echo (json_encode($salida));
        return;
    }else{
        http_response_code(200);
        $salida->rsp        = false;
        $salida->errlvl     = $errlvl;
        $salida->errdsc     = $errMsg;
        echo (json_encode($salida));
        return;
    }
?>

<?php

function parseErrMsg( $errMsg){
    global $db;
    $limiterW = ")";
    $limiterC = "]";
    $pos = strpos($errMsg, $limiterW);
    if( !$pos || empty($pos) ){ $errlvl = 1; }else{ $errlvl = 2; }
    
    // Parse de los mensajes de error para eliminar el numero de error al jSon
    $newErrMsg = "";
    $errArray = explode("|",$errMsg);
    sort($errArray);
    foreach ($errArray as $value) {
        // Se consigue la posicion de ] ó ) en el string para eliminar el numero
        $pos = strpos($value, $limiterW);
        if( !$pos || empty($pos) ){ 
            $pos = strpos($value, $limiterC); 
        }
        if($pos > 0 && !empty($value)){
            $value = substr( $value, $pos+1);
            $newErrMsg .= $value . "|";
        }
    }
    $errMsg = $errlvl.$newErrMsg;
    return $errMsg;
}

function valerr($errno){
    
    /* errType: Indica si es (1) Warning o (2) Critical error*/
    $errType = 1;
    
    switch ($errno) {
        case 1:
            $errdsc = "No se especificó el CUSTID del cliente";
            $errType = 2;
            break;
        case 2:
            $errdsc = "No se especificó el RIF del cliente";
            $errType = 2;
            break;
        case 3:
            $errdsc = "No se especificó el APODO del cliente";
            break;            
        case 4:
            $errdsc = "No se especificó el NOMBRE o RAZON SOCIAL del cliente";
            break;
            $errType = 2;
        case 5:
            $errdsc = "No se especificó el CORREO ELECTRONICO del cliente";
            break;            
        case 6:
            $errdsc = "Existe un cliente registrado previamente con el mismo valor de CUSTID";
            $errType = 2;
            break;    
        case 7:
            $errdsc = "Existe un cliente registrado previamente con el mismo valor de RIF";
            $errType = 2;
            break;    
        case 8:
            $errdsc = "Existe un cliente registrado previamente con el mismo valor de APODO";
            $errType = 2;
            break;    
        case 9:
            $errdsc = "Existe un cliente registrado previamente con el mismo valor de NOMBRE o RAZON SOCIAL";
            break;            
        case 10:
            $errdsc = "Dirección de correo no es válida.";
            $errType = 2;
            break;
        case 11:
            $errdsc = "Número de RIF o su formato no es válido.";
            $errType = 2;
        break;    
        default:
            $errdsc = "";
            $errType = 0;
    } 
    
    // Se asignan [] para los warning y () para los critical
    if($errType > 0){
        if($errType == 1){ $errType = "[".$errno."] "; }else{ $errType = "(".$errno.") ";}
    }

    return $errType.$errdsc."|";
}

function val_registro(){
    global $db;
    $errMsg = "";

    $customerid = $_REQUEST["id"]*1;
    $custid     = $_REQUEST["custid"]*1;
    $rif        = $_REQUEST["rif"];
    $nickname   = $_REQUEST["nickname"];
    $name       = $_REQUEST["name"];
    $email      = $_REQUEST["email"];
    if (isset($_REQUEST["status"])) { $status = 1;}else{$status = 0;}

    if(empty($custid))  { $errMsg .= valerr(1);}
    if(empty($rif))     {
        $errMsg .= valerr(2);
    }else{
        if (!valrif( $rif)) {
            $errMsg .= valerr(11);
        }
    }
    if(empty($nickname)){ $errMsg .= valerr(3);}
    if(empty($name))    { $errMsg .= valerr(4);}
    if(empty($email))   { $errMsg .= valerr(5);}

    // Se valida de que no exista previamente ----
    
    if( chkprevreg( "custid   = ".$custid ) )       { $errMsg .= valerr(6);}
    if( chkprevreg( "rif      = '".$rif."'" ) )     { $errMsg .= valerr(7);}
    if( chkprevreg( "nickname = '".$nickname."'" ) ){ $errMsg .= valerr(8);}
    if( chkprevreg( "name     = '".$name."'" ) )    { $errMsg .= valerr(9);}

    // Se valida el correo electronico valido
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errMsg .= valerr(10);
    }

    


    return $errMsg;
}

function chkprevreg( $where){
    global $db;
    $salida = false;
    $id = $_REQUEST["id"]*1;
    
    if(empty($id)){
        $sql = "SELECT id FROM customers WHERE " . $where  ;    
    }else{
        $sql = "SELECT id FROM customers WHERE id <> " .$id . " AND " . $where  ;
    }

    if (!($qry = mysqli_query($db, $sql))){
        
        http_response_code(500);
        $salida->rsp = false ;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }
    
    $numofrecords = mysqli_num_rows($qry) ;  
    
    if ($numofrecords > 0){ $salida = true;}

    return $salida;
}

/**
 * Validar formato del RIF
 *
 * Basado en el método módulo 11 para el cálculo del dígito verificador
 * y aplicando las modificaciones propias ejecutadas por el seniat
 * @link http://es.wikipedia.org/wiki/C%C3%B3digo_de_control#C.C3.A1lculo_del_d.C3.ADgito_verificador
 *
 * @return boolean
 */
function valrif( $rif) {
    global $db;
    $retorno = preg_match("/^([VEJPG]{1})([0-9]{9}$)/", $rif);
    if ($retorno) {
        $digitos = str_split($rif);
        $digitos[8] *= 2;
        $digitos[7] *= 3;
        $digitos[6] *= 4;
        $digitos[5] *= 5;
        $digitos[4] *= 6;
        $digitos[3] *= 7;
        $digitos[2] *= 2;
        $digitos[1] *= 3;
        // Determinar dígito especial según la inicial del RIF
        // Regla introducida por el SENIAT
        switch ($digitos[0]) {
            case 'V':
                $digitoEspecial = 1;
                break;
            case 'E':
                $digitoEspecial = 2;
                break;
            case 'C':
            case 'J':
                $digitoEspecial = 3;
                break;
            case 'P':
                $digitoEspecial = 4;
                break;
            case 'G':
                $digitoEspecial = 5;
                break;
        }
        $suma = (array_sum($digitos) - $digitos[9]) + ($digitoEspecial*4);
        $residuo = $suma % 11;
        $resta = 11 - $residuo;
        $digitoVerificador = ($resta >= 10) ? 0 : $resta;
        if ($digitoVerificador != $digitos[9]) {
            $retorno = false;
        }
    }
    return $retorno;
}



?>
