<?php
    include("../connection.php");
    include($_SERVER['DOCUMENT_ROOT']."/mlretenciones/Aws/amazon-ses.php");
    //include("../../../Aws/amazon-ses.php");

    $errMsg = "";
    if (!isset($_REQUEST["email"]) || empty($_REQUEST["email"]) ) { $errMsg .= "No se recibio el Parametro email. "; } 
    
    $salida = new stdClass();

    if (!empty($errMsg) ){
        http_response_code(400);
        $salida->send = false;
        $salida->msg = $errMsg;
        echo (json_encode($salida));
        return;
    }

    $email = strtoupper(preg_replace("/[^a-zA-Z0-9@._-]/", "", $db->real_escape_string($_REQUEST["email"])));

    mysqli_query($db,"SET lc_time_names = 'es_ES'");

    $sql =  "SELECT id, name, pwd, IF(CURDATE()>validthru, 1, 0) as loginvencido, failscount, blocked " . 
            "FROM   users " .
            "WHERE  UPPER(email) = ? " ;
    
    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("s", $email);

    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp   = false;
        $salida->errno = 1;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }

    //Obtenemos los resultados y recorremos
    $result = $stmt->get_result();
    if (!($rs = mysqli_fetch_array($result))){
    	switch (mysqli_errno($db)){
    	case 0:
    	    http_response_code(401);
            $salida->rsp   = false;
            $salida->errno = 2;
            $salida->msg = "No registrado";
            echo (json_encode($salida));
            return;
            break;

        default:
        http_response_code(500);
	    $salida->rsp   = false;
            $salida->errno = 3;
            $salida->msg = mysqli_error($db);
            echo (json_encode($salida));
            return;
            break;
    	}
    }
    
    $id                 = $rs["id"];
    $usr_name           = $rs["name"];
    //$srvdate            = $rs["srvdate"];
    $loginvencido       = $rs["loginvencido"];
    $failscount         = $rs["failscount"];
    $blocked            = $rs["blocked"];

    if (!empty($loginvencido)){
        http_response_code(401);
        $salida->rsp   = true;
        $salida->errno = 4;
        $salida->send = true;
        $salida->msg = "Sesión vencida, contacte al administrador";
        echo (json_encode($salida));
        return;
    }

    /* Se blanque cualquier otra session con el mismo numero */
    $sql =  "UPDATE users SET " .
            "             validthru  = NULL, " .
            "             failscount = 0,  " .
            "             blocked    = 0 " .
            "WHERE  UPPER(email) = ? ";
    
    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("s", $email);

    if (!($stmt->execute())){       
        http_response_code(500);
        $salida->rsp   = false;
        $salida->errno = 5;
        $salida->msg = mysqli_error($db);
        //$salida->sql = $sql;
        echo (json_encode($salida));
        return;
    }  
    
    
    session_start();
    $hash     = session_id();
    $hash     = substr( $hash, rand(5, 9), rand(6, 10));
    $urlnewpwd = "ttt";
    session_unset(); 
    session_destroy(); 
    
    $to      =  [$email];
    $subject =  "MercadoLibre - Recuperación de clave";
    $headers  = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= 'From: <webmaster@example.com>' . "\r\n";
    
     $msg   = "«html»";
     $msg  .= "      «head» ";
     $msg  .= "          «title»MercadoLibre - Recuperación de clave«/title»";
     $msg  .= "      «/head»";
     $msg  .= "      «body»";
     $msg  .= "          «p»¡Hola!«/p»";
     $msg  .= "          «p»";
     $msg  .= "          En respuesta a tu solicitud de «b»Recuperación de clave«/b»,";
     $msg  .= "          se reiniciará tu cuenta y debes cambiarla, presionando ahora el botón  ";
     $msg  .= "          «b»Continuar«/b»";
     $msg  .= "          «/p»";
     $msg  .= "          «p»Coloca tu nueva clave de seguridad y el código suministrado aquí para garantizar la veracidad:«/p»";
     $msg  .= "          «b»".$hash."«/b»";
     $msg  .= "          «p»Cualquier duda o problema, contacta al administrador del sistema«/p»";
     $msg  .= "          Saludos,";
     $msg  .= "          «/p»";
     $msg  .= "          «p»";
     $msg  .= "          Mercado Libre";
     $msg  .= "          «/p»";
     $msg  .= "          «h6»Nota: Este es un correo no supervisado, favor no responder. «/h6»";
     $msg  .= "      «/body»";
     $msg  .= "«/html» ";
     $msg = str_replace("«","<",$msg);
     $msg = str_replace("»",">",$msg);

    //mail($to,$subject,$msg,$headers);
    //FUNCION PARA REALIZAR ENVÍOS CON AMAZON SES
    enviarEmail($to,$subject,$msg);

    
    $sql =  "UPDATE users SET ".
                        " status     = 1, " .
                        " pin = '".strtoupper($hash)."', ".
                        " failscount = 0, " .
                        " validthru = DATE_ADD(NOW(), INTERVAL 1 YEAR), " .
                        " blocked    = 0 " .
            " WHERE  id=" . $id;
            
    if (!(mysqli_query($db,$sql))){
        http_response_code(500);
        $salida->rsp   = false;
        //$salida->sql   = $sql;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }
    
    header("Content-Type:application/json");
    http_response_code(200);
    $salida->rsp   = true;
    $salida->msg   = "Su solicitud fue atendida";
    //$salida->sql   = $sql;
    echo (json_encode($salida));
    return;
?>



