<?php
    header("Content-Type:application/json");
    include("../connection.php");
    $errMsg = "";
    if (!isset($_REQUEST["sessid"]) || empty($_REQUEST["sessid"]) ) { $errMsg .= "No se recibio el Parametro sessid. "; }
    if (!isset($_REQUEST["id"])     || empty($_REQUEST["id"]) )     { $errMsg .= "No se recibio el Parametro id. "; } 
    
    $salida = new stdClass();
    
    if (!empty($errMsg) ){
        http_response_code(400);
        $salida->msg = $errMsg;
        echo (json_encode($salida));
        return;
    }
    $sessid     = preg_replace("/[^a-zA-Z0-9]/", "", $db->real_escape_string($_REQUEST["sessid"]));
    $documentid = intval($db->real_escape_string($_REQUEST["id"]));
    
    mysqli_query($db, "SET lc_time_names = 'es_ES'");

    /* Se valida el usuario y la session */
    $sql =  "SELECT id FROM customers WHERE sessionid = ? AND IF(CURDATE()<sessionvalidthru, 1, 0)" ;

    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("s", $sessid);
            
    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = false ;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }
    
    $result = $stmt->get_result();
    if (!($rs = mysqli_fetch_array($result))){
        switch (mysqli_errno($db)){
        case 0:
            http_response_code(401);
            $salida->rsp = false ;
            $salida->msg = "Sesión inválida o caduca";
            $salida->errno = 0;
            //$salida->sql = $sql;
            echo (json_encode($salida));
            return;
            break;
        default:
            http_response_code(500);
            $salida->rsp = false ;
            $salida->msg = mysqli_error($db);
            echo (json_encode($salida));
            return;
            break;
        }
    }

    //$sessid = $_REQUEST["customerid"];

    /* Se valida el usuario y la session */
    $sql =  "SELECT documents.id as documentid, documents.doctype, ".
            "       DATE_FORMAT(documents.docdate,'%d/%m/%Y') as docdate, " .
            "       documents.docnumber, documents.doccontrol,  documents.base, ".
            "       documents.total, documents.pagado, ". 
            "       documents.errlvl, documents.errdsc, " .
            "       IF(ISNULL(retislr.id),false,true) as switchislr, ". 
            "       IF(ISNULL(retislr.status),'',retislr.status) as islrstatus, ". 
            "       DATE_FORMAT(retislr.islrdate,'%d/%m/%Y') as islrdate, ". 
            "       IF(ISNULL(retislr.islrnumber),'',retislr.islrnumber) as islrnumber, ".
            "       IF(ISNULL(retislr.amount),0,retislr.amount) as islramount, ". 
            "       DATE_FORMAT(retislr.repdate,'%d/%m/%Y') as islrrepdate, ".
            "       IF(ISNULL(retiva.id),false,true) as switchiva, ". 
            "       IF(ISNULL(retiva.status),'',retiva.status) as ivastatus, ".
            "       DATE_FORMAT(retiva.ivadate,'%d/%m/%Y') as ivadate, ".
            "       IF(ISNULL(retiva.ivanumber),'',retiva.ivanumber)as ivanumber, ". 
            "       IF(ISNULL(retiva.amount),0,retiva.amount)  as ivaamount, ".
            "       DATE_FORMAT(retiva.repdate,'%d/%m/%Y') as ivarepdate ". 
            "   FROM        documents " .
            "   LEFT JOIN   retislr       ON documents.id = retislr.documentid " .
            "   LEFT JOIN   retiva        ON documents.id = retiva.documentid " .
            "   INNER JOIN  customers c   ON c.id  =  documents.customerid " .
            "   WHERE       c.sessionid =  ? " .
            "   AND         documents.id = ? " ;
            
    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("ss", $sessid, $documentid);
            
    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = false ;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }
    
    $result = $stmt->get_result();
    if (!($rs = mysqli_fetch_array($result))){
        switch (mysqli_errno($db)){
        case 0:
            http_response_code(401);
            $salida->rsp = false ;
            $salida->msg = "Sesion inválida o caduca";
            $salida->errno = 0;
            echo (json_encode($salida));
            return;
            break;
        default:
            http_response_code(500);
            $salida->rsp = false ;
            $salida->msg = mysqli_error($db);
            echo (json_encode($salida));
            return;
            break;
        }
    }else{
        $documentid = $rs["documentid"]*1;
        $docdate    = $rs["docdate"];
        $doctype    = $rs["doctype"]*1;
        $docnumber  = $rs["docnumber"];
        $doccontrol = $rs["doccontrol"];
        $base       = $rs["base"]*1;
        $total      = $rs["total"]*1;
        $pagado     = $rs["pagado"]*1;
        $errlvl     = $rs["errlvl"]*1;
        $errdsc     = $rs["errdsc"];
        
        $switchislr = $rs["switchislr"];
        $islrstatus = $rs["islrstatus"];
        $islrdate   = $rs["islrdate"];
        $islrnumber = $rs["islrnumber"];
        $islramount = $rs["islramount"]*1;
        $islrrepdate= $rs["islrrepdate"];

        $switchiva  = $rs["switchiva"];
        $ivastatus  = $rs["ivastatus"];
        $ivadate    = $rs["ivadate"];
        $ivanumber  = $rs["ivanumber"];
        $ivaamount  = $rs["ivaamount"]*1;
        $ivarepdate = $rs["ivarepdate"];
        
        http_response_code(200);
        $salida->rsp = true ;
        $salida->documentid = $documentid ;
        $salida->docdate    = $docdate    ;
        $salida->doctype    = $doctype    ;
        $salida->docnumber  = $docnumber  ;
        $salida->doccontrol = $doccontrol ;
        $salida->base       = $base       ;
        $salida->total      = $total      ;
        $salida->pagado     = $pagado     ;
        $salida->errlvl     = $errlvl     ;
        $salida->errdsc     = $errdsc     ;
        
        $salida->switchislr = $switchislr ;
        $salida->islrstatus = $islrstatus ;
        $salida->islrdate   = $islrdate   ;
        $salida->islrnumber = $islrnumber ;
        $salida->islramount = $islramount ;
        $salida->islrrepdate= $islrrepdate;
        
        $salida->switchiva  = $switchiva ;
        $salida->ivastatus  = $ivastatus  ;
        $salida->ivadate    = $ivadate    ;
        $salida->ivanumber  = $ivanumber  ;
        $salida->ivaamount  = $ivaamount  ;
        $salida->ivarepdate = $ivarepdate ;
        echo (json_encode($salida));
        return;

        
    }
    


?>
