<?php
    header("Content-Type:application/json");
    include("../connection.php");
    
    $salida = new stdClass();

    if (!isset($_GET["id"]) && !isset($_GET["sessionid"])){
        http_response_code(400);
        $salida->msg = "No se recibio el parámetro id/sessionid";
        echo (json_encode($salida));
        return;
    }

    $id = intval($db->real_escape_string($_GET["id"]));
    $sessid = preg_replace("/[^a-zA-Z0-9]/", "", $db->real_escape_string($_GET["sessionid"]));
    
    $sql =  "SELECT sessionvalidthru, DATEDIFF(IFNULL(sessionvalidthru,NOW()), NOW()) active " .
            "FROM   customers " .
            "WHERE  id = ? " .
            "AND    sessionid = ?";
            
    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("is", $id, $sessid);
            
    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }
    
    //Obtenemos los resultados y recorremos
    $result = $stmt->get_result();
    if (!($rs = mysqli_fetch_array($result))){
        switch (mysqli_errno($db)){
        case 0:
            http_response_code(401);
            $salida->msg = "Sesión Inválida";
            echo (json_encode($salida));
            return;
            break;
        default:
            http_response_code(500);
            $salida->msg = mysqli_error($db);
            echo (json_encode($salida));
            return;
            break;
        }
    }
    if ($rs["active"] < 0){
        http_response_code(401);
        $salida->msg = "Sesión Inválida";
        echo (json_encode($salida));
        return;
    }
    
    
    $sql =  "UPDATE customers SET    sessionid = NULL, sessionvalidthru = NOW() WHERE  id= ?";
        
    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("i", $id);
            
    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }
          
    http_response_code(200);
    $salida->msg = "Salida de sistema exitosa";
    echo (json_encode($salida));
?>