<?php
    header("Content-Type:application/json");
    include("../connection.php");
    //include($_SERVER['DOCUMENT_ROOT']."/mlretenciones/Aws/amazon-ses.php");
     
    $errMsg = "";
    if (!isset($_REQUEST["customer"])   || empty($_REQUEST["customer"]) || !is_numeric($_REQUEST["customer"]) )   { $errMsg .= "Parametro customer invalido. "; } 
    if (!isset($_REQUEST["rif"])        || empty($_REQUEST["rif"]))         { $errMsg .= "No se recibio el Parametro rif. "; } 
    
    $salida = new stdClass();
    
    if (empty($errMsg)){
        if (!is_numeric(substr($_REQUEST["rif"], 1)))
            $errMsg .= "Parametro rif invalido";
    }
 
    if (!empty($errMsg) ){
        http_response_code(400);
        $salida->rsp = false;
        $salida->msg = $errMsg;
        echo (json_encode($salida));
        return;
    }

    $customer   = strtoupper(preg_replace("/[^a-zA-Z0-9]/", "", $db->real_escape_string($_REQUEST["customer"])));
    $rif        = strtoupper(preg_replace("/[^JGEVP0-9\-]/", "", $db->real_escape_string($_REQUEST["rif"])));
     
    mysqli_query($db, "SET lc_time_names = 'es_ES'");
 
    $sql =  "SELECT id, email, RIGHT(CAST(RAND(6) AS CHAR),10) as pin, " .
            "       sessionid, " .
            "       IF(CURDATE()>sessionvalidthru, 1, 0) as sessionvencio, " .
            "       IF(CURDATE()>validthru, 1, 0) as loginvencido, blocked, NOW AS srvdate  " . 
            "FROM   customers " .
            "WHERE  UPPER(custid) = ? " .
             " AND  UPPER(rif)  = ? " ;
 
             
    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("ss", $customer, $rif);
            
    //Validamos la ejecuci贸n
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = false;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }
    
    //Obtenemos los resultados y recorremos
    $result = $stmt->get_result();
    $rs = mysqli_fetch_array($result);
    if (empty($rs)){
        http_response_code(401);
        $salida->rsp = true;
        $salida->msg = "No podemos conseguir tú información";
        echo (json_encode($salida));
        return;
    }

    session_start();     
    $sessid             = session_id();
    session_unset(); 
    session_destroy(); 
    
    $id                 = $rs["id"];
    $email              = $rs["email"];
        $mail_segments    = explode("@", $email);
        $lgnMail          = $mail_segments[0];
        if (strlen($mail_segments[0]) > 6){
            // $mail_segments[0] = substr($mail_segments[0],0,3).str_repeat("*", strlen($mail_segments[0])-6).substr($mail_segments[0],-3);
            $long_seg  = strlen($mail_segments[0]);
            $cutstrpos = intval((( $long_seg -3)/2));
            $mail_segments[0] = substr($mail_segments[0],0, $cutstrpos) . "***" . substr($mail_segments[0], (($long_seg-$cutstrpos-3)*-1));
        }else{
            $mail_segments[0] = substr($mail_segments[0],0,3).str_repeat("*", strlen($mail_segments[0]));
        }
        if (strlen($mail_segments[1]) > 6){
            $mail_segments[1] = substr($mail_segments[1],0,3).str_repeat("*", strlen($mail_segments[1])-6).substr($mail_segments[1],-3);//
            $long_seg  = strlen($mail_segments[1]);
            $cutstrpos = intval((( $long_seg -3)/2));
            $mail_segments[1] = substr($mail_segments[1],0, $cutstrpos) . "***" . substr($mail_segments[1], (($long_seg-$cutstrpos-3)*-1));
        }
        $show_mail        = implode("@", $mail_segments);  
    $srvdate            = $rs["srvdate"];
    $loginvencido       = $rs["loginvencido"];
    $blocked            = $rs["blocked"];
 
    $code = substr($sessid, 0, 4) . substr($sessid, -4);
 
    if (!empty($blocked)){
        http_response_code(401);
        $salida->rsp = true;
        $salida->msg = utf8_encode("Tienes bloqueado el acceso al sistema. Ya fué notificado a Mercado Libre"); // 
        echo (json_encode($salida));
        return;
    }
 
     /* Se registra la session del usuario y se limpia el numero de intentos fallidos y usuario bloqueado 
        se coloca limite de tiempo para culminar el registro */
    $sql =  "UPDATE customers SET ".
            "       pin              = '".$code."', " .
            "       sessionid        = '" .$sessid. "', " .
            "       failscount       = 0, " .
            "       blocked          = 0, " .
            "       validthru        = DATE_ADD(NOW(), INTERVAL 1 YEAR), " .
            "       sessionvalidthru = DATE_ADD(NOW(), INTERVAL 1 HOUR) " .
            "WHERE  id = " . $id ;
            
    if (!(mysqli_query($db, $sql))){
        http_response_code(500);
        $salida->rps = false;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }    

    /* Envio de correo electronico con el ping de ingreso */
    $to      =  [$email];
    $subject =  "MercadoLibre - Registro de usuario";
    /* Always set content-type when sending HTML email */
    $headers  = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= 'From: <webmaster@example.com>' . "\r\n";
    $headers .= 'Cc: myboss@example.com' . "\r\n";            
    
    $msg   = "«html»";
    $msg  .= "      «head» ";
    $msg  .= "          «title»MercadoLibre - Registro de usuario«/title»";
    $msg  .= "      «/head»";
    $msg  .= "      «body»";
    $msg  .= "          «p»¡Hola!«/p»";
    $msg  .= "          «p»";
    $msg  .= "          En respuesta a tu solicitud de registro enviamos tu código: «b»" . $code . "«/b»,";
    $msg  .= "          de seguridad. Tiene una validez temporal, recuerda completarlo a la brevedad.";
    $msg  .= "          «/p»";
    $msg  .= "          «p»";
    $msg  .= "          Saludos,";
    $msg  .= "          «/p»";
    $msg  .= "          «p»";
    $msg  .= "          Mercado Libre";
    $msg  .= "          «/p»";
    $msg  .= "          «h6»Nota: Este es un correo no supervisado, favor no responder. «/h6»";
    $msg  .= "      «/body»";
    $msg  .= "«/html» ";
    $msg = str_replace("«","<",$msg);
    $msg = str_replace("»",">",$msg);

    //mail($to,$subject,$msg,$headers);
    enviarEmail($to,$subject,$msg);
     
    http_response_code(200);
    $salida->rsp        = true;
    $salida->rif        = $rif;
    $salida->email      = $show_mail;
    $salida->validata   = $sessid;
    echo (json_encode($salida));
 ?>
 