<?php
    //header("Content-Type:application/json");
    include("../connection.php");
    $errMsg = "";
    if (!isset($_REQUEST["sessid"]) || empty($_REQUEST["sessid"]) ) { $errMsg .= "No se recibio el Parametro sessid. "; } 
    if (!isset($_REQUEST["userid"]) || empty($_REQUEST["userid"]) ) { $errMsg .= "No se recibio el Parametro userid. "; }
    if (!isset($_REQUEST["clave"])  || empty($_REQUEST["clave"]) )  { $errMsg .= "No se recibio el Parametro clave. "; } 
    
    $salida = new stdClass();
    
    if (!empty($errMsg) ){
        http_response_code(400);
        $salida->rsp = false;
        $salida->msg = $errMsg;
        echo (json_encode($salida));
        return;
    }

    $sessid     = strtoupper(preg_replace("/[^a-zA-Z0-9]/", "", $db->real_escape_string($_REQUEST["sessid"])));
    $userid     = intval($db->real_escape_string($_REQUEST["userid"]));
    $clave      = strtoupper(preg_replace("/[^a-zA-Z0-9*@#_.]/", "", $db->real_escape_string($_REQUEST["clave"])));

    mysqli_query($db, "SET lc_time_names = 'es_ES'");
 
    $sql =  "SELECT id as userid, rif  " .
            "FROM   customers " .
            "WHERE         id = ? ".
            "  AND  sessionid = ? ".
            "  AND  IF(CURDATE()<sessionvalidthru, 1, 0) ";

     //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("is", $userid, $sessid);
            
    //Validamos la ejecuci贸n
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = false;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }

    //Obtenemos los resultados y recorremos
    $result = $stmt->get_result();
    $rs = mysqli_fetch_array($result);
    if (empty($rs)){
        http_response_code(401);
        $salida->rsp = true;
        $salida->msg = "Su tiempo vencio";
        //$salida->sql = $sql;
        echo (json_encode($salida));
        return;
    }

    $userid = $rs["userid"];

    $sql =  "UPDATE customers SET   sessionid = '', " .
                            "       pwd = ?, " .
                            "       pin = '', " .
                            "       failscount = 0, " .
                            "       blocked    = 0 " .
            "WHERE  id= ? ";
            
     //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("ss", $clave, $userid);
            
    //Validamos la ejecuci贸n
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }
    
    http_response_code(200);
    $salida->rsp    = true;
    $salida->userid = $userid;
    echo (json_encode($salida));
 ?>
 