/* global $ */

var page_home = {
    loaded: false,
    baseUrl: "https://retenciones.mercadolibre.com.ve/mlretenciones",
    //baseUrl: "..",
    on_load: function(){
        if(!page_home.loaded){
            var obj;
            obj = document.getElementById("mnuico").addEventListener("click", page_home.showmnu);
            obj = document.getElementById("usrmnu").addEventListener("click", page_home.usrpref_open);
            obj = document.getElementById("icon_close").addEventListener("click", page_home.usrpref_close);
            obj = document.getElementById("form_btnctl").addEventListener("click", page_home.savepass);
            obj = document.getElementById("logout").addEventListener("click", page_home.logout);
            obj = document.getElementById("frm_save").addEventListener("click", page_home.form.savefrm);
            obj = document.getElementById("frm_close").addEventListener("click", page_home.form.close);
            page_home.grid.construction();
            page_home.loaded = true;
            global.on_load();
        }
    },
    grid: {
        format: {
            column: {
                errshw: function(value,row,index){
                    var salida = "";
                    if (parseInt(row.status) !== 0){
                        salida = {class:'archiveShow'};
                    }else{
                        switch (parseInt(row.errlvl)){
                            case 1:
                                salida = {class:'warningShow'};
                                break;
                            case 2:
                                salida = {class:'errorShow'};
                                break;
                            case 3:
                                salida = {class:'errorShow'};
                            break;
                        }
                    }
                    return salida;
                 },
                 islrpdfshow: function(value,row,index){
                     var salida = "";
                     if (row.islr_pdf){
                         salida = {class:'pdfShow'};
                     }
                     return salida;
                 },
                 ivapdfshow: function(value,row,index){
                     var salida = "";
                     if (row.iva_pdf){
                         salida = {class:'pdfShow'};
                     }
                     return salida;
                 }

            }
        },
        islrPdfShow: function(i){
            var row = $("#invoices").datagrid('getRows')[i];
            if (row.islr_pdf){
                page_home.grid.pdfShow(row.islr_pdf);
            }
        },
        ivaPdfShow: function(i){
            var row = $("#invoices").datagrid('getRows')[i];
            if (row.iva_pdf){
                page_home.grid.pdfShow(row.iva_pdf);
            }
        },
        pdfShow: function(url){//XXX
            var sessionid = $("#sessid").html();
            var dir;
            if (url.indexOf("islr")>=0)
                dir = "islr";
            else
                dir = "iva";
            var ref = url.replace(/^.*[\\\/]/, '').split(".")[0];
            var pag = page_home.baseUrl + "/customer/api/showpdf.php";
            pag += "?sessionid=" + sessionid;
            pag += "&dir=" + dir;
            pag += "&ref=" + ref;
            window.open(pag, "_blank", "width=400,height=500");
            //window.open(page_home.baseUrl + url, "_blank", "width=400,height=500");
        },
        errShow: function(i){
            var row = $("#invoices").datagrid('getRows')[i];
            var titulo = "";
            var msg = "";
            var header = "";
            switch (row.errlvl){
                case 1:
                    titulo = "Advertencia";
                    msg = row.errdsc.slice(0, -1);
                    header = "<p style='font-size:80%'>Esta factura podrá ser procesado aunque hemos encontrado algunas inconsistencias.</p>";
                    break;
                case 2:
                    titulo = "Error";
                    msg = row.errdsc.slice(0, -1);
                    header = "<p style='font-size:80%'>Esta factura no se enviará para su procesamiento hasta que no se resuelvan los errores.</p>";
                    break;
                case 3:
                    titulo = "Mensaje de Mercado Libre";
                    msg = row.errdsc.slice(0, -1);
                    header = "<p style='font-size:80%'>Esta factura no se enviará para su procesamiento hasta que no se resuelvan los errores.</p>";
                    break;
            }
            
            if (msg.length){
                msg = "<ul><li>" + msg.replace(/\|/g, "</li><li>") + "</li></ul>";
                $.messager.alert(titulo, header + msg);
            }
        },
        construction: function(){
            var getlist="api/invoices/getlist.php?sessid="+$("#sessid").html();
            var anchoCol = parseInt(window.innerWidth*0.95/13);
            
            // la altura debe hacerse antes de inyectar el codigo del grid
            $("#invoices").css("height", $(".invoices").height()+"px");
            
            /*#invoices"*/
            $("#invoices").datagrid({
                url: getlist,
                /*width: (window.innerWidth*0.95)+"px",*/
                striped: true,
                fitColumns: true,
                autoRowHeight: true,
                singleSelect: true,
                loadMsg: "Cargando Información...",
                emptyMsg: "No hay información, incluya una factura",
                showHeader: true,
                showFooter: true,
                pagination: true,
                pageSize: 20,
                idField: "documentid",
                columns:[
                    [
                    {title:"", halign:"center", colspan:11},
                    {title:"ISLR", halign:"center", colspan:5},
                    {title:"IVA", halign:"center", colspan:5}
                    ],
                    [
                    {width: 0,          align:"left",    halign:"center", field:"status",      title:"ST",    hidden:true},
                    {width: 0,          align:"left",    halign:"center", field:"documentid",  title:"ID",    hidden:true},
                    {width: 0,          align:"left",    halign:"center", field:"errdsc",      title:"Error", hidden:true},
                    {width: 0,          align:"left",    halign:"center", field:"errlvl",      title:"Error", hidden:true},
                    {width: anchoCol/3, align:"center",  halign:"center", field:"errshw",      title:"", styler:page_home.grid.format.column.errshw},
                    {width: anchoCol,   align:"center",  halign:"center", field:"fdocdate",    title:"Fecha"},
                    {width: anchoCol,   align:"center",  halign:"center", field:"docnumber",   title:"Número"},
                    {width: anchoCol,   align:"center",  halign:"center", field:"doccontrol",  title:"Control"},
                    {width: anchoCol,   align:"right",   halign:"right",  field:"base",        title:"Base"},
                    {width: anchoCol,   align:"right",   halign:"right",  field:"total",       title:"Total"},
                    {width: anchoCol,   align:"right",   halign:"right",  field:"pagado",      title:"Pagado"},
                    {width: anchoCol,   align:"center",  halign:"center", field:"islr_date",   title:"Fecha"},
                    {width: anchoCol,   align:"center",  halign:"center", field:"islr_number", title:"Número"},
                    {width: anchoCol,   align:"right",   halign:"right",  field:"islr_amount", title:"Monto"},
                    {width: 0,          align:"left",    halign:"center", field:"islr_pdf",    title:"Error", hidden:true},
                    {width: anchoCol/3, align:"center",  halign:"center", field:"islrpdfshow", title:"&nbsp;", styler:page_home.grid.format.column.islrpdfshow},
                    {width: anchoCol,   align:"center",  halign:"center", field:"iva_date",    title:"Fecha"},
                    {width: anchoCol,   align:"center",  halign:"center", field:"iva_number",  title:"Número"},
                    {width: anchoCol,   align:"right",   halign:"right",  field:"iva_amount",  title:"Monto"},
                    {width: 0,          align:"left",    halign:"center", field:"iva_pdf",     title:"Error", hidden:true},
                    {width: anchoCol/3, align:"center",  halign:"center", field:"ivapdfshow",  title:"&nbsp;", styler:page_home.grid.format.column.ivapdfshow},
                    ]
                ],
                toolbar: [{
                            iconCls: 'icon-add',
                            text: 'Incluir',
                            handler: page_home.form.add
                         },'-', {
                            iconCls: 'icon-edit',
                            text: 'Editar',
                            handler: page_home.form.edit
                         },'-',{
                            iconCls: 'icon-remove',
                            text: 'Eliminar',
                            handler: page_home.form.del
                }],
                onLoadSuccess: function(){
                    $("#datagrid-td-group1-0-1").css("background-color", "#dfdfdf");
                    $("#datagrid-td-group1-0-2").css("background-color", "#555");
                },
                onLoadError: function(e){
                    //console.log(e);
                    $.messager.alert("No se puede mostrar la información", e.responseJSON.msg); 
                },
                onClickCell: function(index, field, value){
                    switch (field){
                        case "errshw":
                            page_home.grid.errShow(index);
                            break;
                        case "islrpdfshow":
                            page_home.grid.islrPdfShow(index);
                            break;
                        case "ivapdfshow":
                            page_home.grid.ivaPdfShow(index);
                            break;
                    }
                }
            });
            
            page_home.form.construction();
        }
    },
    form: {
        status: 0,
        construction: function(){
            // FACTURA
            $("#docdate").datebox({
                label: 'Fecha:',
                labelPosition: 'top',
                required: true,
                missingMessage: 'Fecha de la factura a la que se retuvo',
                formatter: function(date){
                    var y = date.getFullYear();
                    var m = date.getMonth()+1;
                    var d = date.getDate();
                    return (d<10?('0'+d):d) + '/' + (m<10?('0'+m):m) + '/' + y;
                },
                parser: function(s){
                    if (!s) return new Date();
                    var ss = (s.split('/'));
                    var d = parseInt(ss[0],10);
                    var m = parseInt(ss[1],10);
                    var y = parseInt(ss[2],10);
                    if (!isNaN(y) && !isNaN(m) && !isNaN(d)){
                        return new Date(y,m-1,d);
                    } else {
                        return new Date();
                    }
                }
            });
            $("#docnumber").textbox({
                label:'Factura N°:',
                labelPosition:'top',
                required:true,
                missingMessage:'Número de la factura a la que se retuvo'
            });
            $("#doccontrol").textbox({
                label:'Control N°:',
                labelPosition:'top',
                required:true,
                missingMessage:'Número de control de la factura'
            });
            $("#base").numberbox({
                label:'Base Imponible:',
                labelPosition:'top',
                decimalSeparator:',',
                groupSeparator:'.',
                min:0,
                precision:2,
                required:true,
                missingMessage:'Monto de la base imponible de la factura'
            });
            $("#total").numberbox({
                label:'Total Factura.:',
                labelPosition:'top',
                decimalSeparator:',',
                groupSeparator:'.',
                min:0,
                precision:2,
                required:true,
                missingMessage:'Monto total de la factura incluidos los impuestos'
            });
            $("#pagado").numberbox({
                label:'Neto a Pagar:',
                labelPosition:'top',
                decimalSeparator:',',
                groupSeparator:'.',
                min:0,
                precision:2,
                required:true,
                missingMessage:'Monto que se pagó una vez retenidos los impuestos'
            });
            
            // ISLR
            $("#islrswitch").switchbutton({
                checked: true,
                onText: "Sí",
                offText: "No",
                onChange: function(checked){
                    page_home.form.showISLRArea(checked);
                }
            });
            $("#islrdate").datebox({
                label: 'Fecha:',
                labelPosition: 'top',
                required: true,
                disabled: false,
                missingMessage: 'Fecha del comprobante de retención',
                formatter: function(date){
                    var y = date.getFullYear();
                    var m = date.getMonth()+1;
                    var d = date.getDate();
                    return (d<10?('0'+d):d) + '/' + (m<10?('0'+m):m) + '/' + y;
                },
                parser: function(s){
                    if (!s) return new Date();
                    var ss = (s.split('/'));
                    var d = parseInt(ss[0],10);
                    var m = parseInt(ss[1],10);
                    var y = parseInt(ss[2],10);
                    if (!isNaN(y) && !isNaN(m) && !isNaN(d)){
                        return new Date(y,m-1,d);
                    } else {
                        return new Date();
                    }
                }
            });
            $("#islrnumber").textbox({
                label:'Número Comprobante:',
                labelPosition:'top',
                required:true,
                missingMessage:'Número del comprobante de retención'
            });
            $("#islramount").numberbox({
                label:'Monto:',
                labelPosition:'top',
                decimalSeparator:',',
                groupSeparator:'.',
                min:0,
                precision:2,
                required:true,
                missingMessage:'Monto de la retención'
            });
            $("#fileislr").filebox({
                prompt:'PDF de la retención...', 
                buttonText: 'Seleccione Archivo',
                required:false,
                missingMessage:'Archivo PDF de la retención',
                width: "100%"
            });
            
            // IVA
            $("#ivaswitch").switchbutton({
                checked: true,
                onText: "Sí",
                offText: "No",
                onChange: function(checked){
                    page_home.form.showIVAArea(checked);
                }
            });
            $("#ivadate").datebox({
                label: 'Fecha:',
                labelPosition: 'top',
                required: true,
                missingMessage: 'Fecha del comprobante de retención',
                formatter: function(date){
                    var y = date.getFullYear();
                    var m = date.getMonth()+1;
                    var d = date.getDate();
                    return (d<10?('0'+d):d) + '/' + (m<10?('0'+m):m) + '/' + y;
                },
                parser: function(s){
                    if (!s) return new Date();
                    var ss = (s.split('/'));
                    var d = parseInt(ss[0],10);
                    var m = parseInt(ss[1],10);
                    var y = parseInt(ss[2],10);
                    if (!isNaN(y) && !isNaN(m) && !isNaN(d)){
                        return new Date(y,m-1,d);
                    } else {
                        return new Date();
                    }
                }
            });
            $("#ivanumber").textbox({
                label:'Número Comprobante:',
                labelPosition:'top',
                required:true,
                missingMessage:'Número del comprobante de retención'
            });
            $("#ivaamount").numberbox({
                label:'Monto:',
                labelPosition:'top',
                decimalSeparator:',',
                groupSeparator:'.',
                min:0,
                precision:2,
                required:true,
                missingMessage:'Monto de la retención'
            });
            $("#fileiva").filebox({
                prompt:'PDF de la retención...', 
                buttonText: 'Seleccione Archivo',
                required:false,
                missingMessage:'Archivo PDF de la retención'
            });
            
            // BOTONES
            $("#frm_save").linkbutton({
                /*iconCls: "icon-ok"*/
            });
            $("#frm_close").linkbutton({
                /*iconCls: "icon-cancel"*/
            });
            
            $('#dlg').dialog({
                closed: true,
                modal: true,
                border: 'thin'
            });
            $('#progressdlg').dialog({
                title: "Guardando",
                closed: true,
                modal: true,
                border: 'thin'
            });
            
            $('#fm').form({
                iframe: false,
                onLoadSuccess: function(){
                    switch (page_home.form.status){
                        case 0:
                            $("#islrswitch").switchbutton("enable");
                            $("#ivaswitch").switchbutton("enable");
                            $("#frm_save").linkbutton("enable");
                            
                            page_home.form.invoiceArea(true);
                            page_home.form.showISLRArea(true);
                            page_home.form.showIVAArea(true);

                            if ($("#islrdate").val().length){
                                page_home.form.showISLRArea(true);
                                $("#islrswitch").switchbutton("check");
                            }else{
                                page_home.form.showISLRArea(false);
                                $("#islrswitch").switchbutton("uncheck");
                            }
                            if ($("#ivadate").val().length){
                                page_home.form.showIVAArea(true);
                                $("#ivaswitch").switchbutton("check");
                            }else{
                                page_home.form.showIVAArea(false);
                                $("#ivaswitch").switchbutton("uncheck");
                            }
                            break;
                        case 1:
                        case 2:
                        case 3:
                            $("#frm_save").linkbutton("disable");
                            $("#islrswitch").switchbutton("disable");
                            $("#ivaswitch").switchbutton("disable");
                            page_home.form.invoiceArea(false);
                            page_home.form.showISLRArea(false);
                            page_home.form.showIVAArea(false);
                            break;
                    }
                }
            });

        },
        invoiceArea: function(show){
            var action = "disable";
            if (show)
                action = "enable";
            $("#docdate").datebox(action);
            $("#docnumber").textbox(action);
            $("#doccontrol").textbox(action);
            $("#base").numberbox(action);
            $("#total").numberbox(action);
            $("#pagado").numberbox(action);
        },showISLRArea: function(show){
              var action = "disable";
              if (show)
                  action = "enable";
              $("#islrdate").datebox(action);
              $("#islrnumber").textbox(action);
              $("#islramount").numberbox(action);
              $("#fileislr").filebox(action);
          },
        showIVAArea: function(show){
            var action = "disable";
            if (show)
                action = "enable";
            $("#ivadate").datebox(action);
            $("#ivanumber").textbox(action);
            $("#ivaamount").numberbox(action);
            $("#fileiva").filebox(action);
        },
        edit: function(){
            var row = $('#invoices').datagrid('getSelected');
            var sessid = $("#sessid").html();

            if (row){
                var parameterAjax = {   metodo      : "GET",
                                        url         : global.baseUrl + "/invoices/getentry.php",  
                                        parameters  : "?sessid="+sessid+"&id="+row.documentid,
                                        onsucces    : function(json){   
                                                                        var rs = JSON.parse(json);
                                                                        if(rs.rsp){
                                                                            if (rs){
                                                                                page_home.form.status = row.status;
                                                                                $('#dlg').dialog('open').dialog('center').dialog('setTitle','Edición de Factura');
                                                                                $('#fm').form('load',rs);
                                                                            }
                                                                        }else{ 
                                                                            //console.log(json.msg);
                                                                            var msg = json.msg;
                                                                            $.messager.alert('Error al cagar la factura N°'+ row.documentid, msg); 
                                                                        }
                                                                    },
                                        onerror     : function(json){   
                                                                        json = JSON.parse(json);
                                                                        var msg = "";
                                                                        if(json.rsp){
                                                                            msg = json.msg;
                                                                            $.messager.alert('Error al cagar la factura N°'+ row.documentid, msg); 
                                                                        }
                                                                    } 
                                    };
                global.utils.callAjax( parameterAjax);
                
            }else{
                $.messager.alert("Para Editar", "Selecciona algúna factura antes de editar");
            }
        },
        add: function(){
            var sessid = $("#sessid").html();
            $('#dlg').dialog('open').dialog('center').dialog('setTitle','Nueva Factura');
            $('#fm').form('clear');
            $('#invoices').datagrid('clearSelections');
            $("#islrswitch").switchbutton("check");
            $("#ivaswitch").switchbutton("check");
            document.getElementById("_easyui_textbox_input3").setAttribute("placeholder","00-00000000");
        },
        del: function(){
            var row = $('#invoices').datagrid('getSelected');
            page_home.form.status = row.status;
            if (page_home.form.status !==0) return;
            
            var sessid = $("#sessid").html();
            if (row){
                $.messager.confirm( 'Confirme el borrado',
                    '¿Estás seguro de querer eliminar este registro?',
                    function(r){ 
                        if (r){
                            var parameterAjax = {   metodo      : "GET",
                                                     url         : global.baseUrl + "/invoices/delete.php",  
                                                     parameters  : "?sessid="+sessid+"&id="+row.documentid,
                                                     onsucces    : function(json){   
                                                                                     $('#invoices').datagrid('reload');
                                                                                 },
                                                     onerror     : function(json){   
                                                                                     json = JSON.parse(json);
                                                                                     var msg = "";
                                                                                     if(!json.rsp){
                                                                                         msg = json.msg;
                                                                                         $.messager.alert('Error al eliminar la factura N°'+ row.documentid, msg); 
                                                                                     }
                                                                                 } 
                                                 };
                            global.utils.callAjax( parameterAjax);
                        }
                    });
            }else{
                $.messager.alert("Para Borrar", "Selecciona algúna factura antes de borrar");
            }
        },
        close: function(){
            $('#dlg').dialog('close')
        },
        savefrm: function(){
            // prevenir cuando está deshabilitado
            if (page_home.form.status !==0) return;
            var documentid;
            var row = $('#invoices').datagrid('getSelected');
            if(!row){ documentid = 0;}else{ documentid = row.documentid}
            
            $('#fm').form('submit',{
                enctype: "multipart/form-data",
                url: global.baseUrl + "/invoices/update.php"+
                     "?sessid="+$("#sessid").html()+
                     "&customerid="+$("#userid").html()+
                     "&id="+documentid,
                onProgress: function(percent) {
                    $('#progressbar').progressbar("setValue",percent);
                },
                onSubmit: function(){ 
                    if ($(this).form('validate')){
                        $('#progressdlg').dialog('open');
                        $('#progressbar').progressbar("setValue",0);
                        return(true);
                    }else{
                        $.messager.alert("Completa la Información", "Hay campos requeridos que no se están completando");
                        return(false);
                    }
                },
                success:  function(result){
                    $('#progressdlg').dialog('close');
                    var jsonresp;
                    if (global.utils.isJSON(result)){
                        jsonresp = JSON.parse(result);
                    }else{
                        jsonresp = {
                                    rsp: false,
                                    errno: 99,
                                    msg: result
                        }
                    }
                    if (!jsonresp.rsp){
                        $.messager.show({ title: 'Error:'+jsonresp.errno, msg: jsonresp.msg});
                    }else{
                        if (jsonresp.errlvl == 1){
                            $.messager.alert("Guardado con Advertencias", "Se ha guardado la factura pero se han reportado algunas advertencias.");
                        }
                        if (jsonresp.errlvl == 2){
                            $.messager.alert("Guardado con Errores", "Se ha guardado la factura pero no será procesado hasta que atienda los errores ocurridos.");
                        }

                        $('#dlg').dialog('close');
                        $('#invoices').datagrid('reload');
                    }
                }
            });
        },
        valdatos: function(){
             // Obtener las variables del formulario getFormData
             var varfrm = {};
             
             $('input').each(function () { varfrm[this.name] = this.value;  });
         
             var validtasaiva  = [0, 12, 22, 16, 26];
             var validtasaislr = [0, 1, 2, 5];
             var errorMsg = "";
             var total      = Number(varfrm.total);
             var base       = Number(varfrm.base);
             var pagado     = Number(varfrm.pagado);
             var islramount = Number(varfrm.islramount);
             var ivaamount  = Number(varfrm.ivaamount);
             var tasaiva    = ((total-base)/base)*100;
             var tasaislr   = (islramount/base)*100;

             if((total-(pagado+ivaamount+islramount))>0){
                 errorMsg += "<br>- Discrepancia entre el total de la factura, retenciones y lo pagado.";
             }
             
             if (varfrm.islrnumber.length > 0){
                 if(validtasaislr.indexOf(tasaislr) < 0){
                     errorMsg += "<br>- Revise la Tasa del ISLR.";
                 }
                 if (varfrm.islrnumber.length > 0 && varfrm.fileislr.length === 0) {
                     errorMsg += "<br>- No se adjunto el comprobante del ISLR.";
                 }
             }
             
             if (varfrm.ivanumber.length > 0){
                 if(validtasaiva.indexOf(tasaiva) < 0){
                     errorMsg += "<br>- Revise la Tasa del IVA.";
                 }
                 if (varfrm.ivanumber.length > 0 && varfrm.fileiva.length === 0) {
                     errorMsg += "<br>- No se adjunto el comprobante del IVA.";
                 }
             }

            if (errorMsg.length > 0){
                errorMsg = "Se localizaron algunas observaciones que deberia revisar: <br><br>" + errorMsg ;
                $.messager.show({ title: 'Aviso', msg:errorMsg});
            }
             return true;            
         }
    },
    usrpref_open: function(){
        var sessid  = document.getElementById("sessid").innerHTML;
        var userid  = document.getElementById("userid").innerHTML;
        var parameterAjax = {   metodo      : "GET",
                                url         : global.baseUrl + "/home/custinfo_check.php",  
                                parameters  : "?sessid="+sessid+"&userid="+userid,
                                onsucces    : function(json){   
                                                                json = JSON.parse(json);
                                                                if(json.rsp){
                                                                    document.getElementById("hupf_custname").innerHTML = json.custname;
                                                                    document.getElementById("hupf_custid").innerHTML = json.custid;
                                                                    document.getElementById("hupf_custmail").innerHTML = json.custmail;
                                                                    document.getElementById("home_usrprofile").style = "display:block;";
                                                                }
                                                            },
                                onerror     : function(json){   
                                                                json = JSON.parse(json);
                                                                var msg = "";
                                                                if(json.rsp){
                                                                    msg = json.msg;
                                                                }
                                                            } 
                            };
        global.utils.callAjax( parameterAjax);
    },
    usrpref_close: function(){
        document.getElementById("home_usrprofile").style = "display:none;";
    },
    showmnu: function(){
        if(  document.getElementById("mnuico").innerHTML.trim() == '<i class="fas fa-angle-down"></i>' ){ 
            document.getElementById("mnuico").innerHTML ='<i class="fas fa-angle-up"></i>';
            document.getElementById("menu").style.display = "block";
        }else{ 
            document.getElementById("mnuico").innerHTML ='<i class="fas fa-angle-down"></i>';
            document.getElementById("menu").style.display = "";
        }
    },
    logout: function(){
        var sessid   = document.getElementById("sessid").innerHTML;
        var parameterAjax = {   metodo      : "GET",
                                url         : global.baseUrl + "/login/logout.php",  
                                parameters  : "?sessid="+sessid,
                                onsucces    : function(json){   
                                                                //json = JSON.parse(json);
                                                                //if(json.rsp){
                                                                    global.utils.goPage("?id=login");
                                                                //}
                                                            },
                                onerror     : function(json){ 
                                                                global.utils.goPage("?id=login");
                                                                /*                                                                
                                                                json = JSON.parse(json);
                                                                var msg = "";
                                                                if(json.rsp){
                                                                    msg = json.msg;
                                                                }
                                                                */
                                                            } 
                            };
        global.utils.callAjax( parameterAjax);
    },
    savepass: function(){
        var sessid  = document.getElementById("sessid").innerHTML;
        var userid  = document.getElementById("userid").innerHTML;
        var clave   = document.getElementById("clave1").value;
        clave   = global.utils.MD5( clave);
        var parameterAjax = {   metodo      : "GET",
                                url         : global.baseUrl + "/login/si_addpass.php",  
                                parameters  : "?sessid="+sessid+"&userid="+userid+"&clave="+clave,
                                onsucces    : function(json){   
                                                                json = JSON.parse(json);
                                                                if(json.rsp){
                                                                    global.utils.goPage("?id=login");
                                                                }
                                                            },
                                onerror     : function(json){   
                                                                json = JSON.parse(json);
                                                                var msg = "";
                                                                if(json.rsp){
                                                                    msg = json.msg;
                                                                }
                                                            } 
                            };
        global.utils.callAjax( parameterAjax);
    },
    frmreturnclick: function(){
        global.utils.goPage("?id=singup");
    },
    frmjumpclick: function(){
        var rif = document.getElementById("valrif").innerHTML;
        global.utils.goPage("?id=si_mailerror&rif="+rif);
    },
};
page_home.on_load();